async function registerPush() {
    const registration = await navigator.serviceWorker.register('https://new2025.sanskrittranslator.org/service-worker.js');
    console.log('Service Worker registered:', registration);

    const convertedKey = urlBase64ToUint8Array(PUBLIC_VAPID_KEY);

    const subscription = await registration.pushManager.subscribe({
        userVisibleOnly: true,
        applicationServerKey: convertedKey,
    });

    console.log('Push Subscription:', subscription);

    // Send the subscription to the server
    await fetch('https://new2025.sanskrittranslator.org/save-token.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(subscription),
    });

    alert('Token saved successfully!');
}

function urlBase64ToUint8Array(base64String) {
    const padding = '='.repeat((4 - (base64String.length % 4)) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
    const rawData = atob(base64);
    const outputArray = new Uint8Array(rawData.length);
    for (let i = 0; i < rawData.length; ++i) {
        outputArray[i] = rawData.charCodeAt(i);
    }
    return outputArray;
}

document.addEventListener('DOMContentLoaded', registerPush);
